/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.engineyard.ui.wizard;

import com.aptana.deploy.ILoginValidator;
import com.aptana.deploy.engineyard.EngineYardAPI;
import com.aptana.deploy.engineyard.EngineYardPlugin;
import com.aptana.deploy.engineyard.ui.wizard.EngineYardDeployWizardPage;
import com.aptana.deploy.engineyard.ui.wizard.EngineYardSignupPage;
import com.aptana.deploy.engineyard.ui.wizard.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EngineYardLoginWizardPage
extends WizardPage
implements ILoginValidator {
    private static final String NAME = "EngineYardLogin";
    private static final String ENGINE_YARD_ICON = "icons/ey_small_wizard.png";
    private Text userId;
    private Text password;
    private IWizardPage fNextPage;

    protected EngineYardLoginWizardPage() {
        super(NAME, Messages.EngineYardLoginWizardPage_Title, EngineYardPlugin.getImageDescriptor(ENGINE_YARD_ICON));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.setControl((Control)composite);
        this.initializeDialogUnits((Control)parent);
        Label label = new Label(composite, 0);
        label.setText(Messages.EngineYardLoginWizardPage_EnterCredentialsLabel);
        Composite credentials = new Composite(composite, 0);
        credentials.setLayout((Layout)new GridLayout(2, false));
        Label userIdLabel = new Label(credentials, 0);
        userIdLabel.setText(Messages.EngineYardLoginWizardPage_EmailAddressLabel);
        this.userId = new Text(credentials, 2052);
        this.userId.setMessage(Messages.EngineYardLoginWizardPage_EmailAddressExample);
        GridData gd = new GridData(300, -1);
        this.userId.setLayoutData((Object)gd);
        this.userId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EngineYardLoginWizardPage.this.getContainer().updateButtons();
            }
        });
        Label passwordLabel = new Label(credentials, 0);
        passwordLabel.setText(Messages.EngineYardLoginWizardPage_PasswordLabel);
        this.password = new Text(credentials, 0x400804);
        this.password.setMessage(Messages.EngineYardLoginWizardPage_PasswordExample);
        this.password.setLayoutData((Object)gd);
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EngineYardLoginWizardPage.this.getContainer().updateButtons();
            }
        });
        Button checkAuth = new Button(credentials, 8);
        checkAuth.setText(Messages.EngineYardLoginWizardPage_SubmitButtonLabel);
        checkAuth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EngineYardLoginWizardPage.this.validateLogin() && EngineYardLoginWizardPage.this.isPageComplete()) {
                    EngineYardLoginWizardPage.this.getContainer().showPage(EngineYardLoginWizardPage.this.getNextPage());
                }
            }
        });
        Link link = new Link(composite, 0);
        link.setText(Messages.EngineYardLoginWizardPage_SignupLinkLabel);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EngineYardSignupPage signupPage = new EngineYardSignupPage(EngineYardLoginWizardPage.this.userId.getText());
                signupPage.setWizard(EngineYardLoginWizardPage.this.getWizard());
                EngineYardLoginWizardPage.this.getContainer().showPage((IWizardPage)signupPage);
            }
        });
        Dialog.applyDialogFont((Control)composite);
    }

    public IWizardPage getNextPage() {
        if (this.fNextPage == null) {
            this.fNextPage = new EngineYardDeployWizardPage();
            this.fNextPage.setWizard(this.getWizard());
        }
        return this.fNextPage;
    }

    public boolean isPageComplete() {
        String userId = this.userId.getText();
        if (userId == null || userId.trim().length() < 1) {
            this.setErrorMessage(Messages.EngineYardLoginWizardPage_EmptyEmailAddressLabel);
            return false;
        }
        String password = this.password.getText();
        if (password == null || password.trim().length() < 1) {
            this.setErrorMessage(Messages.EngineYardLoginWizardPage_EmptyPasswordLabel);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean validateLogin() {
        EngineYardAPI api = new EngineYardAPI();
        if (!api.writeCredentials(this.userId.getText(), this.password.getText())) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.EngineYardLoginWizardPage_ErrorTitle, (String)Messages.EngineYardLoginWizardPage_InvalidCredentails_Message);
            return false;
        }
        return true;
    }
}

